﻿using System;
using System.Collections.Generic;
using System.Text;

namespace LFS_External_Client
{
    class cars
    {
        static public string addCar(string carsString, int carNumber)
        {
            string tempString1;
            string tempString2;
            tempString1 = carsString.Remove(carNumber - 1, 1);
            tempString2 = tempString1.Insert(carNumber - 1, "1");
            return tempString2;
        }
        static public string addCar(string carsString, string carName)
        {
            string tempString1;
            string tempString2;
            tempString1 = carsString.Remove(getCarNumber(carName) - 1, 1);
            tempString2 = tempString1.Insert(getCarNumber(carName) - 1, "1");
            return tempString2;
        }

        static public string delCar(string carsString, int carNumber)
        {
            string tempString1;
            string tempString2;
            tempString1 = carsString.Remove(carNumber - 1, 1);
            tempString2 = tempString1.Insert(carNumber - 1, "0");
            return tempString2;
        }
        static public string delCar(string carsString, string carName)
        {
            string tempString1;
            string tempString2;
            tempString1 = carsString.Remove(getCarNumber(carName) - 1, 1);
            tempString2 = tempString1.Insert(getCarNumber(carName) - 1, "0");
            return tempString2;
        }

        static public bool carIncl(string carsString, int carNumber)
        {
            try
            {
                if (carsString.Substring(carNumber - 1, 1) == "1")
                {
                    return true;
                }
                else if (carsString.Substring(carNumber - 1, 1) == "0")
                {
                    return false;
                }
                else
                {
                    misc.buildErrorReportOnCrash(new Exception("Returned integer is not recognised in cars.carIncl."), "CCI-RVU-CPMT:RTR", "CCI", ("carsString = " + carsString + "|carNumber = " + carNumber).Split('|'), "|C|C|I|");
                    return true;
                }
            }
            catch (Exception E)
            {
                misc.buildErrorReportOnCrash(E, "CCI-ERC-CPMT:RTR", "CCI", ("carsString = " + carsString + "|carNumber = " + carNumber).Split('|'), "|C|C|I|");
                //CCI = Cars.CarIncl ; RVU = Returned Value Unknown ; CPMT = Crash Protection Measures Taken ; RTR = Returned TRue ; ERC = Error Report Caught
                return true;
            }
        }
        static public bool carIncl(string carsString, string carName)
        {
            try
            {
                if (carsString.Substring(getCarNumber(carName) - 1, 1) == "1")
                {
                    return true;
                }
                else if (carsString.Substring(getCarNumber(carName) - 1, 1) == "0")
                {
                    return false;
                }
                else
                {
                    misc.buildErrorReportOnCrash(new Exception("Returned string is not recognised in cars.carIncl."), "CCI-RVU-CPMT:RTR", "CCI", ("carsString = " + carsString + "|carName = " + carName).Split('|'), "|C|C|I|");
                    return true;
                }
            }
            catch (Exception E)
            {
                misc.buildErrorReportOnCrash(E, "CCI-ERC-CPMT:RTR", "CCI", ("carsString = " + carsString + "|carName = " + carName).Split('|'), "|C|C|I|");
                //CCI = Cars.CarIncl ; RVU = Returned Value Unknown ; CPMT = Crash Protection Measures Taken ; RTR = Returned TRue ; ERC = Error Report Caught
                return true;
            }
        }
        
        static public bool carExists(string car)
        {
            switch (car.ToUpper())
            {
                case "UF1": return true;
                case "XFG": return true;
                case "XRG": return true;
                case "LX4": return true;
                case "LX6": return true;
                case "RB4": return true;
                case "FXO": return true;
                case "XRT": return true;
                case "RAC": return true;
                case "FZ5": return true;
                case "VWS": return false;
                case "UFR": return true;
                case "XFR": return true;
                case "FXR": return true;
                case "XRR": return true;
                case "FZR": return true;
                case "MRT": return true;
                case "FBM": return true;
                case "FOX": return true;
                case "FO8": return true;
                case "BF1": return true;
            }
            return false;
        }

        static public int numCars(string carsString)
        {
            int numCars = 0;
            string carsString2 = carsString;
            carsString2 = carsString2.Replace("6", "1");
            carsString2 = carsString2.Replace("5", "1");
            carsString2 = carsString2.Replace("4", "1");
            carsString2 = carsString2.Replace("3", "1");
            carsString2 = carsString2.Replace("2", "1");
            while (carsString2.Contains("1") == true)
            {
                carsString2 = delCar(carsString2, carsString2.IndexOf("1") + 1);
                numCars += 1;
            }
            return numCars;
        }
        
        static public int getCarNumber(string carName)
        {
            switch (carName.ToUpper())
            {
                case "UF1": return 1;
                case "XFG": return 2;
                case "XRG": return 3;
                case "LX4": return 4;
                case "LX6": return 5;
                case "RB4": return 6;
                case "FXO": return 7;
                case "XRT": return 8;
                case "RAC": return 9;
                case "FZ5": return 10;
                case "VWS": return 0;
                case "UFR": return 11;
                case "XFR": return 12;
                case "FXR": return 13;
                case "XRR": return 14;
                case "FZR": return 15;
                case "MRT": return 16;
                case "FBM": return 17;
                case "FOX": return 18;
                case "FO8": return 19;
                case "BF1": return 20;
                case "SUM": return 20;
            }
            return 0;
        }
        
        static public string getCarName(int carNumber)
        {
            switch (carNumber)
            {
                case 1: return "UF1";
                case 2: return "XFG";
                case 3: return "XRG";
                case 4: return "LX4";
                case 5: return "LX6";
                case 6: return "RB4";
                case 7: return "FXO";
                case 8: return "XRT";
                case 9: return "RAC";
                case 10: return "FZ5";
                case 0: return "XXX";
                case 11: return "UFR";
                case 12: return "XFR";
                case 13: return "FXR";
                case 14: return "XRR";
                case 15: return "FZR";
                case 16: return "MRT";
                case 17: return "FBM";
                case 18: return "FOX";
                case 19: return "FO8";
                case 20: return "BF1";
            }
            return "XXX";
        }
        
        static public byte maxAddMass(string car)
        {
            switch (car.ToUpper())
            {
                case "UF1": return 120;
                case "XFG": return 190;
                case "XRG": return 200;
                case "LX4": return 100;
                case "LX6": return 110;
                case "RB4": return 200;
                case "FXO": return 200;
                case "XRT": return 200;
                case "RAC": return 160;
                case "FZ5": return 200;
                case "VWS": return 0;
                case "UFR": return 120;
                case "XFR": return 170;
                case "FXR": return 200;
                case "XRR": return 200;
                case "FZR": return 200;
                case "MRT": return 40;
                case "FBM": return 90;
                case "FOX": return 100;
                case "FO8": return 120;
                case "BF1": return 110;
            }
            return 0;
        }

        static public string mergeTwoCarsStrings(string carsString1, string carsString2, bool destroyEachOther)
        {
            string returnString = carsString1;
            if (carsString1 == carsString2)
            {
                return returnString;
            }
            else
            {
                for (int i = 1; i <= getCarNumber("SUM"); i++)
                {
                    if (destroyEachOther == false)
                    {
                        if (misc.matrixIsNotZero(i, carsString2) == true)
                        {
                            returnString = misc.matrixAdd(i, returnString);
                        }
                    }
                    else
                    {
                        if (misc.matrixIsNotZero(i, carsString2) == false)
                        {
                            returnString = misc.matrixDel(i, returnString);
                        }
                    }
                }
            }
            return returnString;
        }

        static public string getAllowedRandCar()
        {
            string endString = mergeTwoCarsStrings(mergeTwoCarsStrings(globalVars.allowedCarsTemp, globalVars.allowedCarsServer, true), globalVars.allowedCarsGlobal, true);
            if (globalVars.allowLastRaceCar == false)
            {
                endString = misc.matrixDel(getCarNumber(Form1.lastRaceCar), endString);
            }
            int carSerialNumb = misc.getRandNum(misc.matrixIndexSum(endString, false));
            string returnString = getCarName(misc.matrixIndexSerialNumber(carSerialNumb, endString, false));
            if (returnString == "XXX")
            {
                Form1.InSim.Send_MST_Message("/msg ^3» ^7Car rand. pick failed. Out of bounds: " + misc.matrixIndexSerialNumber(carSerialNumb, endString, false));
                Form1.InSim.Send_MST_Message("/msg ^3» ^7matrixIndexSerialNumber = " + misc.matrixIndexSerialNumber(carSerialNumb, endString, false));
                Form1.InSim.Send_MST_Message("/msg ^3» ^7matrixIndexSum(endString, false) = " + misc.matrixIndexSum(endString, false));
                Form1.InSim.Send_MST_Message("/msg ^3» ^7carSerialNumb = " + carSerialNumb);
                Form1.InSim.Send_MST_Message("/msg ^3» ^7endString = " + endString);
                return "FOX";
            }
            return returnString;
        }

        static public bool carAllowed(string carName)
        {
            string endString = mergeTwoCarsStrings(mergeTwoCarsStrings(globalVars.allowedCarsTemp, globalVars.allowedCarsServer, true), globalVars.allowedCarsGlobal, true);

            return misc.matrixIsNotZero(getCarNumber(carName), endString);
        }
        static public bool carAllowed(int carNumber)
        {
            string endString = mergeTwoCarsStrings(mergeTwoCarsStrings(globalVars.allowedCarsTemp, globalVars.allowedCarsServer, true), globalVars.allowedCarsGlobal, true);

            return misc.matrixIsNotZero(carNumber, endString);
        }

        static public bool carAllowedAdmin(string carName)
        {
            return misc.matrixIsNotZero(getCarNumber(carName), globalVars.allowedCarsGlobal);
        }
        static public bool carAllowedAdmin(int carNumber)
        {
            return misc.matrixIsNotZero(carNumber, globalVars.allowedCarsGlobal);
        }

        static public string getCurrentlyAllowedServerCars()
        {
            string endString = mergeTwoCarsStrings(mergeTwoCarsStrings(globalVars.allowedCarsTemp, globalVars.allowedCarsServer, true), globalVars.allowedCarsGlobal, true);
            string returnString = "";

            for (int i = 1; i <= getCarNumber("SUM"); i++)
            {
                if (misc.matrixIsNotZero(i, endString) == true)
                {
                    returnString += getCarName(i) + " ";
                }
            }

            if (returnString == "")
            {
                return "_undetected";
            }
            else
            {
                return returnString.Remove(returnString.Length - 1);
            }
        }

        static public string getAllowedCarsString(string matrixString)
        {
            string returnString = "";

            for (int i = 1; i <= 20; i++)
            {
                if (misc.matrixIsNotZero(i, matrixString) == true)
                {
                    returnString += getCarName(i) + " ";
                }
            }

            if (returnString == "")
            {
                return "_undetected";
            }
            else
            {
                return returnString.Remove(returnString.Length - 1);
            }
        }
    }
}
